require("dotenv").config();
const { PrismaClient } = require("@prisma/client");
const { PrismaMariaDb } = require("@prisma/adapter-mariadb");

const adapter = new PrismaMariaDb({
  host: process.env.DB_HOST,        // e.g. 5.9.106.155
  port: Number(process.env.DB_PORT || 3306),
  user: process.env.DB_USER,        // e.g. heart
  password: process.env.DB_PASSWORD,// e.g. Antor@123
  database: process.env.DB_NAME,    // e.g. ai_blog
});

const prisma = new PrismaClient({ adapter });

module.exports = prisma;
