// src/controllers/admin/author.controller.js
const authorService = require("../../services/author.service");
const { success, error } = require("../../utils/response");

// CREATE AUTHOR (already exists)
exports.createAuthor = async (req, res, next) => {
  try {
    const { name, avatar, bio } = req.body;
    if (!name) return error(res, "Author name is required", 400);

    const author = await authorService.createAuthor({ name, avatar, bio });
    return success(res, author, "Author created", 201);
  } catch (err) {
    next(err);
  }
};

// ✅ NEW: LIST ALL AUTHORS FOR ADMIN
exports.getAllAdminAuthors = async (req, res, next) => {
  try {
    const authors = await authorService.getAllAuthors();
    return success(res, authors);
  } catch (err) {
    next(err);
  }
};
