// src/controllers/admin/category.controller.js
const categoryService = require("../../services/category.service");
const { success, error } = require("../../utils/response");

// CREATE CATEGORY (already exists)
exports.createCategory = async (req, res, next) => {
  try {
    const { name, slug } = req.body;
    if (!name) return error(res, "Category name is required", 400);

    const category = await categoryService.createCategory({ name, slug });
    return success(res, category, "Category created", 201);
  } catch (err) {
    next(err);
  }
};

// ✅ NEW: LIST ALL CATEGORIES FOR ADMIN
exports.getAllAdminCategories = async (req, res, next) => {
  try {
    const categories = await categoryService.getAllCategories();
    return success(res, categories);
  } catch (err) {
    next(err);
  }
};
