// src/controllers/admin/tag.controller.js
const tagService = require("../../services/tag.service");
const { success, error } = require("../../utils/response");

// CREATE TAG (already exists)
exports.createTag = async (req, res, next) => {
  try {
    const { name, slug } = req.body;
    if (!name) return error(res, "Tag name is required", 400);

    const tag = await tagService.createTag({ name, slug });
    return success(res, tag, "Tag created", 201);
  } catch (err) {
    next(err);
  }
};

// ✅ NEW: LIST ALL TAGS FOR ADMIN
exports.getAllAdminTags = async (req, res, next) => {
  try {
    const tags = await tagService.getAllTags();
    return success(res, tags);
  } catch (err) {
    next(err);
  }
};
