// src/controllers/public/post.controller.js
const postService = require("../../services/post.service");
const { success, error } = require("../../utils/response");

exports.getAllPosts = async (req, res, next) => {
  try {
    // now supports filters & pagination
    const result = await postService.getPostsAdvanced(req.query);
    return success(res, result);
  } catch (err) {
    next(err);
  }
};

exports.getSinglePost = async (req, res, next) => {
  try {
    const { slug } = req.params;
    const post = await postService.getPostBySlug(slug);
    if (!post) return error(res, "Post not found", 404);
    return success(res, post);
  } catch (err) {
    next(err);
  }
};
