const postService = require("../../services/post.service");
const { success } = require("../../utils/response");

exports.searchPosts = async (req, res, next) => {
  try {
    const q = req.query.q || "";
    if (!q.trim()) return success(res, [], "No query provided");
    const posts = await postService.searchPosts(q.trim());
    return success(res, posts);
  } catch (err) {
    next(err);
  }
};
