const { error } = require("../utils/response");

function errorHandler(err, req, res, next) {
  console.error(err);

  const status = err.status || 500;
  const message = err.message || "Internal server error";

  return error(res, message, status, process.env.NODE_ENV === "development" ? err.stack : undefined);
}

module.exports = errorHandler;
