// src/services/admin.service.js
const prisma = require("../config/db");

async function findAdminByEmail(email) {
  return prisma.adminUser.findUnique({
    where: { email }
  });
}

async function createAdmin({ email, password, role = "admin" }) {
  return prisma.adminUser.create({
    data: { email, password, role }
  });
}

async function getAdminCount() {
  return prisma.adminUser.count();
}

module.exports = {
  findAdminByEmail,
  createAdmin,
  getAdminCount
};
