// src/services/author.service.js
const prisma = require("../config/db");

async function getAllAuthors() {
  return prisma.author.findMany({
    orderBy: { name: "asc" }
  });
}

async function createAuthor({ name, avatar, bio }) {
  if (!name) throw new Error("Author name is required");

  return prisma.author.create({
    data: {
      name,
      avatar: avatar || null,
      bio: bio || null
    }
  });
}

module.exports = {
  getAllAuthors,
  createAuthor
};
