const prisma = require("../config/db");

async function createSeoForPost(postId, seo) {
  return prisma.seo.create({
    data: {
      postId,
      title: seo.title,
      description: seo.description,
      keywords: seo.keywords ? seo.keywords.join(",") : null,
      ogImage: seo.ogImage || null,
      ogType: seo.ogType || "article"
    }
  });
}

async function updateSeoForPost(postId, seo) {
  return prisma.seo.upsert({
    where: { postId },
    create: {
      postId,
      title: seo.title,
      description: seo.description,
      keywords: seo.keywords ? seo.keywords.join(",") : null,
      ogImage: seo.ogImage || null,
      ogType: seo.ogType || "article"
    },
    update: {
      title: seo.title,
      description: seo.description,
      keywords: seo.keywords ? seo.keywords.join(",") : null,
      ogImage: seo.ogImage || null,
      ogType: seo.ogType || "article"
    }
  });
}

module.exports = {
  createSeoForPost,
  updateSeoForPost
};
