function validatePost(body) {
  const errors = [];

  if (!body.title) errors.push("Title is required");
  if (!body.slug) errors.push("Slug is required");
  if (!body.excerpt) errors.push("Excerpt is required");
  if (!body.content) errors.push("Content is required");
  if (!body.categoryId) errors.push("categoryId is required");
  if (!body.authorId) errors.push("authorId is required");

  if (!Array.isArray(body.tags)) {
    errors.push("tags must be an array of tag IDs");
  }

  if (!body.seo || !body.seo.title || !body.seo.description) {
    errors.push("SEO title and description are required");
  }

  return {
    valid: errors.length === 0,
    errors
  };
}

module.exports = { validatePost };
